#############################################################################
# Author:                                                                   #
# ------                                                                    #
#  Anton Kokalj                                  Email: Tone.Kokalj@ijs.si  #
#  Department of Physical and Organic Chemistry  Phone: x 386 1 477 3523    #
#  Jozef Stefan Institute                          Fax: x 386 1 477 3811    #
#  Jamova 39, SI-1000 Ljubljana                                             #
#  SLOVENIA                                                                 #
#                                                                           #
# Source: $XCRYSDEN_TOPDIR/Tcl/interpolate.tcl
# ------                                                                    #
# Copyright (c) 1996-2003 by Anton Kokalj                                   #
#############################################################################

proc FS_Interpolation {title togl spin iband} {
    global FS_Interpolation

    if { ! [info exists FS_Interpolation(counter)] } {
	set FS_Interpolation(counter) 1
    } else {
	incr FS_Interpolation(counter)
    }

    if { ! [info exists FS_Interpolation($togl)] } {
	set FS_Interpolation($togl) 1
    }
    if { ! [info exists FS_Interpolation($togl,window)] } {
	set FS_Interpolation($togl,window) .fs_interp_$FS_Interpolation(counter)
    }
    
    if { [winfo exists $FS_Interpolation($togl,window)] } {
	return
    }

    set t [xcToplevel $FS_Interpolation($togl,window) Interpolation Interpolation]
    
    set f0 [frame $t.0 -class StressText]
    set l0 [label $f0.l -text $title]
    set f1 [frame $t.1 -relief groove -bd 2]
    set f2 [frame $t.2]

    set sc [scale $f1.scale -from 1 -to 5 \
		-length       200 \
		-variable     FS_Interpolation($togl) \
		-orient       horizontal \
		-label        "Degree of LCASI3D Interpolation:" \
		-tickinterval 1 \
		-digits       1 \
		-resolution   1 \
		-showvalue    true \
		-width        10]
    
    set update [button $f2.update -text Submit \
		    -command [list FS_Interpolation:submit $togl $spin $iband]]
    set close  [button $f2.close -text Close \
		    -command [list CancelProc $t]]

    pack $f0 $l0 $f1 $f2 -side top -fill both -expand 1 -padx 10 -pady 10
    pack $sc -expand 1 -pady 10
    pack $close $update -side left -expand 1 -pady 10 -padx 10
}

proc FS_Interpolation:submit {togl spin iband} {
    global FS_Interpolation fs
    
    set fs($spin,$iband,interpolationdegree) [list \
						  $FS_Interpolation($togl) \
						  $FS_Interpolation($togl) \
						  $FS_Interpolation($togl)]
    FS_fsConfig $iband $spin
}
    


