#############################################################################
# Author:                                                                   #
# ------                                                                    #
#  Anton Kokalj                                  Email: Tone.Kokalj@ijs.si  #
#  Department of Physical and Organic Chemistry  Phone: x 386 1 477 3523    #
#  Jozef Stefan Institute                          Fax: x 386 1 477 3811    #
#  Jamova 39, SI-1000 Ljubljana                                             #
#  SLOVENIA                                                                 #
#                                                                           #
# Source: $XCRYSDEN_TOPDIR/Tcl/popup.tcl
# ------                                                                    #
# Copyright (c) 1996-2003 by Anton Kokalj                                   #
#############################################################################

proc FS_PopupMenu {W x y i {spin {}}} {
    global fs

    #set m [menubutton .m -text Display -menu .m.menu]
    #pack $m

    if [winfo exists .menu] {
	destroy .menu
    }
    set mdis [menu .menu -tearoff 0]
    tk_popup .menu $x $y
    $mdis add command -label "PopUp Menu" -state disabled -foreground #000
    $mdis add separator
    $mdis add checkbutton -label "Coordinate System" -variable check(crds) \
	    -command CrdSist
    $mdis add checkbutton -label "Atomic Symbols" -variable check(labels) \
	    -command AtomLabels
    $mdis add checkbutton -label "Crystal Cells" -variable check(frames) \
	    -command CrysFrames
    $mdis add checkbutton -label "Wigner-Seitz Cells" -variable check(wigner) \
	    -command WignerSeitz
    $mdis add checkbutton -label "Pseudo Density" -variable check(pseudoDens) \
	    -command PseudoDensity

    #$m bind $M

    #menubutton $m.vmcolor -image colors     -menu $m.vmcolor.menu
}

bind . <Button-3>               [list FS_PopupMenu . 100 100 1]
#bind . <B3-ButtonRelease> {destroy .menu}