c     ******************************************************
      program MyFormat2XSF
c     Usage: myformat2xsf myformat_file 
c
c     The program reads the myformat file from myformat_file
c     and writes the XSF file to standard output
c     ******************************************************
      implicit none
      integer MAXATOMS
      PARAMETER (MAXATOMS = 1000)
      character*256 my_file
      real*8
     $     primvec(3,3),        ! primitive lattice vectors
     $     convvec(3,3),        ! conventional lattice vectors
     $     coor(3,MAXATOMS)     ! atomic coordinates
      integer
     $     iargc,
     $     nat(MAXATOMS),       ! atomic numbers
     $     iat, i, j, len       ! counters

      if (iargc().ne.1)
     $     stop 'Usage: myformat2xcr myformat_infile'
      
      call getarg(1,my_file)
      len = index(my_file,' ') - 1
      open(unit=1, file=my_file(1:len), status='old')

c     ***
c     *** READ MyFormat file
c     ***
          ... insert code here ...

c     ***
c     *** WRITE XSF file
c     ***

c     ***  lets suppose it is a CRYSTAL structure
c     ***  other posibilites are (SLAB,POLYMER,MOLECULE)

      write(*,*) 'CRYSTAL'
      write(*,*) 'PRIMVEC'
      write(*,1000) primvec
      write(*,*) 'CONVVEC'
      write(*,1000) convvec
      write(*,*) 'PRIMCOORD'
      write(*,*) iat, 1
      do i=1,iat
         write(*,1001) nat(i), (coor(j,i), j=1,3)
      enddo

 1000 format(2(3(F15.9,2X),/),3(F15.9,2X))
 1001 format(I5,3(F15.9,2X))
      END
